#pragma once

#include <mapreduce/yt/interface/client.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NCrypta::NIscryptaLogParser {
    static const TString EXT_ID = "ext_id";
    static const TString TYPE_IDENTIFY = "type: IDENTIFY";
    static const TString TYPE_UPLOAD = "type: UPLOAD";
    static const TString TYPE_EXT_ID = "type: EXT_ID";

    struct TExtId {
        TString Tag;
        TString Value;

        bool operator==(const TExtId& other) const;
        bool operator!=(const TExtId& other) const;
    };

    struct TExtIdMatch {
        TExtId ExtId;
        TString Yandexuid;
        bool Synthetic = false;

        bool operator==(const TExtIdMatch& other) const;
        bool operator!=(const TExtIdMatch& other) const;
    };

    struct TUploadInfo {
        TExtIdMatch Match;
        ui64 Timestamp = 0;

        bool operator==(const TUploadInfo& other) const;
        bool operator!=(const TUploadInfo& other) const;
    };

    struct TIdentifyInfo {
        TExtId ExtId;
        ui64 Timestamp = 0;

        bool operator==(const TIdentifyInfo& other) const;
        bool operator!=(const TIdentifyInfo& other) const;
    };

    bool HasExtIdUploadRequest(const NYT::TNode& row);
    bool HasExtIdIdentifyRequest(const NYT::TNode& row);
    TExtIdMatch ParseExtIdMatch(const TString& request);
    TUploadInfo ParseUploadInfo(const NYT::TNode& row);
    TExtId ParseExtId(const TString& identifyRequest);
    TIdentifyInfo ParseIdentifyInfo(const NYT::TNode& row);
    bool UploadInfoIsValid(const TUploadInfo& info);
}
