#pragma once

#include <crypta/lib/proto/juggler_client/juggler_client_options.pb.h>

#include <util/generic/maybe.h>

namespace NCrypta {
    class IJugglerClient {
    public:
        virtual void ReportOk(const TString& host, const TString& service, const TString& description) = 0;
        virtual void ReportWarn(const TString& host, const TString& service, const TString& description) = 0;
        virtual void ReportCrit(const TString& host, const TString& service, const TString& description) = 0;
        virtual ~IJugglerClient() = default;
    };

    class TJugglerClient : public IJugglerClient {
    public:
        TJugglerClient(const TJugglerClientOptions& options);

        void ReportOk(const TString& host, const TString& service, const TString& description) override;
        void ReportWarn(const TString& host, const TString& service, const TString& description) override;
        void ReportCrit(const TString& host, const TString& service, const TString& description) override;

        ~TJugglerClient() override = default;
    private:
        void ReportStatus(const TString& status, const TString& host, const TString& service, const TString& description);

        const TJugglerClientOptions Options;
    };
}
