#pragma once

#include <crypta/lib/native/database/database.h>
#include <crypta/lib/native/database/reply_handler.h>

#include <util/generic/deque.h>
#include <util/generic/maybe.h>
#include <util/generic/variant.h>

namespace NCrypta {
    class TLocalKv : public IDatabase, public IReplyHandler {
    public:
        TRequestId Get(const TString& key, const TDuration& ttl = TDuration()) override;
        TRequestId Store(const TRecord& record, const TDuration& ttl = TDuration()) override;
        TRequestId Remove(const TString& key, ui64 cas = TRecord::NO_CAS) override;

        bool TryProcessReply() override;

        void SetGetHandler(const TGetHandler& handler) override;
        void SetStoreHandler(const TStoreHandler& handler) override;
        void SetRemoveHandler(const TRemoveHandler& handler) override;
        void SetErrorHandler(const TErrorHandler& handler) override;

        TLocalKv() = default;
        ~TLocalKv() = default;

    private:
        using TStorage = THashMap<TString, TString>;

        struct TGetReply {
            TRequestId RequestId;
            TMaybe<TRecord> Record;
        };
        struct TStoreReply {
            TRequestId RequestId;
            TString Key;
        };
        struct TRemoveReply {
            TRequestId RequestId;
            TString Key;
        };
        struct TErrorReply {
            TRequestId RequestId;
            TString Key;
            TString Error;
        };

        using TReply = std::variant<TGetReply, TStoreReply, TRemoveReply, TErrorReply>;
        using TReplyQueue = TDeque<TReply>;

        TRequestId NextRequestId = 0;

        TStorage Storage;
        TReplyQueue ReplyQueue;

        TGetHandler GetHandler;
        TStoreHandler StoreHandler;
        TRemoveHandler RemoveHandler;
        TErrorHandler ErrorHandler;
    };
}
