#pragma once

#include <spdlog/spdlog.h>
#include <crypta/lib/native/log/proto/log_config.pb.h>
#include <crypta/lib/native/singleton/tagged_singleton.h>

#include <util/generic/hash.h>
#include <util/generic/vector.h>

namespace NCrypta::NLog {
    using TLogPtr = std::shared_ptr<spdlog::logger>;
    using TLogConfigs = ::google::protobuf::Map<TProtoStringType, TLogConfig>;

    TLogPtr GetLog(const TString& name);
    TLogPtr GetLog();

    void RegisterLog(const std::string& logName, const TLogConfig& config);
    void RegisterLogs(const TLogConfigs& config);

    spdlog::level::level_enum ConvertArcadiaToSpdlogLevel(int level);
}
