#include "std_logger.h"

using namespace NCrypta;
using namespace NLog;

TLogPtr NStdLogger::RegisterLog(const TString& name, const TString& type, const TString& level, bool deployFormat) {
    TLogConfig logConfig;
    logConfig.SetLevel(level);
    auto* target = logConfig.AddTargets();
    target->SetType(type);
    target->SetDeployFormat(deployFormat);

    RegisterLog(name, logConfig);
    return GetLog(name);
}
