#include "log_exception.h"

using namespace NCrypta;

void NLog::LogException(const TString& message, const TString& logName) {
    try {
        const auto& log = GetLog(logName);
        log->error("Exception in {}, exiting: {}", logName, message);
    } catch (...) {
        Cerr << "Exception in " << logName << ", exiting " << message << Endl;
    }
}
