#include "pq_spdlog_wrapper.h"

using namespace NPersQueue;

namespace NCrypta {
    namespace NLog {
        TPqSpdlogWrapper::TPqSpdlogWrapper(const TString& logName)
            : Logger(GetLog(logName)) {
        }

        void TPqSpdlogWrapper::Log(const TString& msg, const TString& sourceId, const TString& sessionId, int level) {
            auto spdlog_level = ConvertArcadiaToSpdlogLevel(level);
            Logger->log(spdlog_level, "[{}] [{}] {}", sourceId, sessionId, msg);
        }

        bool TPqSpdlogWrapper::IsEnabled(int level) const {
            return Logger->should_log(ConvertArcadiaToSpdlogLevel(level));
        }

        TLogPtr TPqSpdlogWrapper::GetLogger() {
            return Logger;
        }
    }
}
