#include "tvm_spdlog_wrapper.h"

namespace NCrypta {
    namespace NLog {
        TTvmSpdlogWrapper::TTvmSpdlogWrapper(const TString& logName)
                : Logger(GetLog(logName)) {
        }

        void TTvmSpdlogWrapper::Log(int level, const TString& msg) {
            auto spdlog_level = ConvertArcadiaToSpdlogLevel(level);
            Logger->log(spdlog_level, msg);
        }
    }
}
