#include "metrics_helper.h"

#include <util/stream/str.h>
#include <library/cpp/monlib/encode/text/text.h>
#include <library/cpp/monlib/encode/json/json.h>

namespace NCryptaSolomonMetrics {
    TString TMetricsHelper::Solomonify() const {
        TStringStream where;

        auto encoder = NMonitoring::EncoderJson(&where, 2);
        Metrics.Accept(TInstant::Zero(), encoder.Get());

        return where.Str();
    };

    TString TMetricsHelper::Textify() const {
        TStringStream where;

        auto encoder = NMonitoring::EncoderText(&where, true);
        Metrics.Accept(TInstant::Zero(), encoder.Get());

        return where.Str();
    };
}
