#include "mock_http_server.h"

#include <library/cpp/testing/common/network.h>

void TMockHttpServer::SetCallback(TCallback callback) {
    Callback = std::move(callback);
    if (ServerImpl) {
        ServerImpl->SetCallback(Callback);
    }
}

void TMockHttpServer::Start() {
    Y_ASSERT(!IsStarted());

    ServerImpl = std::make_unique<THttpServerImpl>();
    ServerImpl->SetCallback(Callback);

    auto port = NTesting::GetFreePort();

    Server = std::make_unique<THttpServer>(
        ServerImpl.get(),
        THttpServerOptions()
            .SetHost("localhost")
            .SetPort(port));
    Server->Start();
}

void TMockHttpServer::Stop() {
    Y_ASSERT(IsStarted());

    Server->Stop();
    Server.reset();

    ServerImpl.reset();
}

bool TMockHttpServer::IsStarted() const {
    return Server.operator bool();
}

TString TMockHttpServer::GetHost() const {
    return Server->Options().Host;
}

int TMockHttpServer::GetPort() const {
    return Server->Options().Port;
}

TMockHttpServer::TCallback TMockHttpServer::THttpServerImpl::GetCallback() {
    auto guard = Guard(Lock);
    return Callback;
}

void TMockHttpServer::THttpServerImpl::SetCallback(TCallback callback) {
    auto guard = Guard(Lock);
    Callback = std::move(callback);
}

TClientRequest* TMockHttpServer::THttpServerImpl::CreateClient() {
    return new TRequest(this);
}

TMockHttpServer::THttpServerImpl::TRequest::TRequest(TMockHttpServer::THttpServerImpl* owner)
    : Owner(owner)
{
}

bool TMockHttpServer::THttpServerImpl::TRequest::Reply(void*) {
    TCallback callback;
    if (Owner) {
        callback = Owner->GetCallback();
    }
    if (!callback) {
        Output() << "HTTP/1.0 501 Not Implemented\r\n\r\n";
    } else {
        callback(this);
    }
    return true;
}
