#pragma once

#include <library/cpp/http/server/http.h>

#include <util/system/spinlock.h>

class TMockHttpServer {
public:
    using TCallback = std::function<void(TClientRequest*)>;

    void SetCallback(TCallback callback);

    void Start();
    void Stop();

    bool IsStarted() const;

    TString GetHost() const;
    int GetPort() const;

private:
    class THttpServerImpl: public THttpServer::ICallBack {
    public:
        TCallback GetCallback();
        void SetCallback(TCallback callback);
        virtual TClientRequest* CreateClient() override;

    private:
        class TRequest: public TClientRequest {
        public:
            explicit TRequest(THttpServerImpl* owner);
            virtual bool Reply(void* opaque) override;

        private:
            THttpServerImpl* const Owner;
        };

        TSpinLock Lock;
        TCallback Callback;
    };

    TCallback Callback;

    std::unique_ptr<THttpServerImpl> ServerImpl;
    std::unique_ptr<THttpServer> Server;
};
