#include "neh_sync_multi_client.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <yt/yt/core/actions/future.h>

#include <util/system/thread.h>

using namespace NCrypta;

TNehSyncMultiClient::TNehSyncMultiClient(const TString& threadName)
    : Client(NNeh::CreateMultiClient())
    , Thread(
        SystemThreadFactory()->Run([this, threadName] {
            TThread::SetCurrentThreadName(threadName.c_str());
            Run();
        })
    )
{
}

NYT::TErrorOr<TNehSyncMultiClient::TResponsePtr> TNehSyncMultiClient::Request(const NNeh::TMessage& msg, TDuration timeout) const {
    return Request(msg, timeout.ToDeadLine());
}

NYT::TErrorOr<TNehSyncMultiClient::TResponsePtr> TNehSyncMultiClient::Request(const NNeh::TMessage& msg, TInstant deadline) const {
    try {
        auto promise = NYT::NewPromise<TResponsePtr>();
        auto future = promise.ToFuture();

        NNeh::IMultiClient::TRequest request(msg, deadline, &promise);
        Client->Request(request);

        return WaitForUnique(future);
    } catch (const std::exception& e) {
        return NYT::TError(e);
    }
}

TNehSyncMultiClient::~TNehSyncMultiClient() {
    Client->Interrupt();
    Thread->Join();
}

void TNehSyncMultiClient::Run() {
    NNeh::IMultiClient::TEvent event;

    while (Client->Wait(event)) {
        auto promise = reinterpret_cast<NYT::TPromise<TResponsePtr>*>(event.UserData);

        if (event.Type == NNeh::IMultiClient::TEvent::Response) {
            promise->Set(event.Hndl->Get());
        } else if (event.Type == NNeh::IMultiClient::TEvent::Timeout) {
            event.Hndl->Cancel();
            promise->Set(NYT::TError("Timeout"));
        } else {
            ythrow yexception() << "Unexpected event";
        }
    }
}
