#pragma once

#include <library/cpp/neh/multiclient.h>
#include <yt/yt/core/misc/error.h>

#include <util/thread/factory.h>

namespace NCrypta {
    class TNehSyncMultiClient {
    public:
        using TResponsePtr = THolder<NNeh::TResponse>;

        TNehSyncMultiClient(const TString& threadName);

        NYT::TErrorOr<TResponsePtr> Request(const NNeh::TMessage& msg, TDuration timeout) const;
        NYT::TErrorOr<TResponsePtr> Request(const NNeh::TMessage& msg, TInstant deadline = TInstant::Max()) const;

        ~TNehSyncMultiClient();
    private:
        void Run();

        THolder<NNeh::IMultiClient> Client;
        THolder<IThreadFactory::IThread> Thread;
    };
}