#include "periodic_task.h"

#include <util/system/thread.h>

using namespace NCrypta;

TPeriodicTask::TPeriodicTask(TDuration period, TCallback callback, const TString& threadName, bool firstCallIsImmediate)
    : Period(period)
    , Callback(callback)
    , ThreadName(threadName)
    , FirstCallIsImmediate(firstCallIsImmediate) {
    StopEvent.Signal();
}

TPeriodicTask::~TPeriodicTask() {
    Stop();
}

void TPeriodicTask::Start() {
    TGuard threadGuard(ThreadMutex);
    if (!StopEvent.WaitD(TInstant::Zero())) {
        return;
    }

    StopEvent.Reset();
    Thread = SystemThreadFactory()->Run(this);
}

void TPeriodicTask::Stop() {
    TGuard threadGuard(ThreadMutex);

    StopEvent.Signal();
    if (Thread) {
        Thread->Join();
    }
}

void TPeriodicTask::DoExecute() {
    TThread::SetCurrentThreadName(ThreadName.c_str());

    if (FirstCallIsImmediate) {
        Callback();
    }

    while (!StopEvent.WaitT(Period)) {
        Callback();
    }
}
