#pragma once

#include <util/generic/string.h>
#include <util/system/event.h>
#include <util/system/mutex.h>
#include <util/thread/factory.h>

namespace NCrypta {
    class TPeriodicTask : public IThreadFactory::IThreadAble {
    public:
        using TCallback = std::function<void()>;
        TPeriodicTask(TDuration period, TCallback callback, const TString& threadName, bool firstCallIsImmediate = false);
        ~TPeriodicTask() override;

        void Start();
        void Stop();
        void DoExecute() override;

    private:
        TManualEvent StopEvent;
        THolder<IThreadFactory::IThread> Thread;
        TMutex ThreadMutex;

        TDuration Period;
        TCallback Callback;
        const TString ThreadName;
        bool FirstCallIsImmediate;
    };
}
