#pragma once

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/pqlib/single_partition_producer.h>

#include <library/cpp/threading/chunk_queue/queue.h>
#include <util/string/builder.h>
#include <util/thread/factory.h>

namespace NCrypta::NPQ {
    class TBufferedProducer {
    public:
        TBufferedProducer(NPersQueue::TPQLib& pqLib,
                          const NPersQueue::TProducerSettings& producerSettings,
                          size_t maxChunkSize,
                          TDuration maxFlushInterval,
                          size_t maxInflightBytes,
                          TIntrusivePtr<NPersQueue::ILogger>& logger,
                          NLog::TLogPtr dropLog,
                          const TStats::TSettings& statsSettings);

        virtual ~TBufferedProducer();

        void Start(TDuration timeout = TDuration::Max());
        void Stop(TDuration timeout = TDuration::Max());

        bool TryEnqueue(TString message);
        void Flush();

    private:
        void Run();
        void UpdateInFlightBytesStat();

        NLog::TLogPtr DropLog;
        TStats Stats;

        TSinglePartitionProducer Producer;

        THolder<IThreadFactory::IThread> Thread;
        TAtomic IsRunning = 0;

        NThreading::TRelaxedManyOneQueue<TString> MessagesQueue;

        TStringBuilder Buffer;
        TInstant LastFlushTime;
        TAtomicCounter InFlightBytes = 0;

        const size_t MaxChunkSize = 0;
        const TDuration MaxFlushInterval;
        const long MaxInFlightBytes = 0;
    };
}
