#pragma once

#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/pqlib/proto/consumer_config.pb.h>
#include <crypta/lib/native/pqlib/proto/credentials_config.pb.h>

#include <kikimr/persqueue/sdk/deprecated/cpp/v2/persqueue.h>

#include <util/generic/hash_set.h>

namespace NCrypta::NPQ {
    class TConsumer {
    public:
        using TData = ::google::protobuf::RepeatedPtrField<::google::protobuf::string>;

        class TCreateConsumerTimeoutException : public yexception {};

        struct TEpochCookie {
            ui64 Cookie;
            ui64 Epoch;
        };

        struct TReadResult {
            TData Data;
            TEpochCookie EpochCookie;

            void ClearData();
        };

        TConsumer(
            TAtomicSharedPtr<NPersQueue::TPQLib> pqLib,
            TIntrusivePtr<NPersQueue::ILogger> logger,
            const TConsumerConfig& consumerConfig,
            const std::shared_ptr<NPersQueue::ICredentialsProvider>& credentialsProvider,
            TStats& stats
        );

        TMaybe<TReadResult> GetNextData(TInstant deadline = TInstant::Max());
        TMaybe<TReadResult> GetNextData(TDuration timeout = TDuration::Max());
        void Commit(const TVector<TEpochCookie>& cookies);

    private:
        THolder<NPersQueue::IConsumer> CreateConsumer();

        TAtomicSharedPtr<NPersQueue::TPQLib> PqLib;
        TIntrusivePtr<NPersQueue::ILogger> Logger;
        const NPersQueue::TConsumerSettings ConsumerSettings;
        TStats& Stats;

        TDuration CreateConsumerTimeout;
        THolder<NPersQueue::IConsumer> Consumer;
        NThreading::TFuture<NPersQueue::TConsumerMessage> Future;
        ui64 Epoch = 0;
    };
}
