#include "credentials_provider.h"

using namespace NCrypta::NPQ;

namespace {
    std::shared_ptr<NTvmAuth::TTvmClient> CreateTvmClient(const TCredentialsConfig::TTvmConfig& config) {
        NTvmAuth::NTvmApi::TClientSettings settings;
        settings.SetSelfTvmId(config.GetClientTvmId());
        settings.EnableServiceTicketsFetchOptions(
                config.GetClientTvmSecret(),
                {{config.GetDestinationAlias(), config.GetDestinationTvmId()}}
        );

        NTvmAuth::TLoggerPtr logger = MakeIntrusive<NTvmAuth::TCerrLogger>(config.GetLogPriority());

        return std::make_shared<NTvmAuth::TTvmClient>(settings, logger);
    }
}

std::shared_ptr<NPersQueue::ICredentialsProvider> NCredentialsProvider::Create(const TCredentialsConfig& config, const TIntrusivePtr<NPersQueue::ILogger>& logger) {
    if (config.GetUseSecureTvm()) {
        const auto& tvmClient = CreateTvmClient(config.GetTvm());
        return NPersQueue::CreateTVMCredentialsProvider(tvmClient, logger, config.GetTvm().GetDestinationAlias());
    } else {
        return NPersQueue::CreateInsecureCredentialsProvider();
    }
}
