#include "pqlib.h"

using namespace NCrypta::NPQ;

TAtomicSharedPtr<NPersQueue::TPQLib> NPQLib::Create(const TPQLibConfig& config) {
    NPersQueue::TPQLibSettings settings {
            .ThreadsCount = config.GetWorkerThreads(),
            .CompressionPoolThreads = config.GetCompressionThreads(),
            .GRpcThreads = config.GetGrpcThreads()
    };

    return MakeAtomicShared<NPersQueue::TPQLib>(settings);
}
