#pragma once

#include <crypta/lib/native/pqlib/proto/producer_config.pb.h>
#include <crypta/lib/native/pqlib/buffered_producer.h>
#include <crypta/lib/native/stats/stats.h>

namespace NCrypta::NPQ {
    class IProducer {
    public:
        virtual bool TryEnqueue(size_t partitioner, TString message) = 0;
        virtual bool TryEnqueue(TString message) = 0;

        virtual ~IProducer() = default;
    };

    class TProducer : public IProducer {
    public:
        TProducer(TAtomicSharedPtr<NPersQueue::TPQLib> pqLib,
                  const TProducerConfig& config,
                  const std::shared_ptr<NPersQueue::ICredentialsProvider>& credentialsProvider,
                  const TStats::TSettings& statsSettings);

        virtual ~TProducer();

        bool TryEnqueue(size_t partitioner, TString message) override;
        bool TryEnqueue(TString message) override;

        void Stop(TDuration timeout = TDuration::Max());

    private:
        void Start(TDuration timeout = TDuration::Max());

        TAtomicSharedPtr<NPersQueue::TPQLib> PqLib;
        TVector<THolder<TBufferedProducer>> Producers;

        TIntrusivePtr<NPersQueue::ILogger> Logger;
    };
}
