#include "reader.h"
#include "consumer.h"

using namespace NCrypta;
using namespace NCrypta::NPQ;

TReader::TReader(
    TDuration readTimeout,
    NPQ::TConsumer& consumer,
    TCookieQueue& cookiesToCommit,
    TProcessFunction processFunction,
    NLog::TLogPtr log
)
    : TThreaded("TReader")
    , ReadTimeout(readTimeout)
    , Consumer(consumer)
    , CookiesToCommit(cookiesToCommit)
    , ProcessFunction(processFunction)
    , Log(log)
{
}

void TReader::Run() {
    try {
        while (IsRunning()) {
            TVector <NPQ::TConsumer::TEpochCookie> cookies;
            CookiesToCommit.DequeueAll(&cookies);
            Consumer.Commit(cookies);

            if (auto readResult = Consumer.GetNextData(ReadTimeout)) {
                ProcessFunction(std::move(*readResult));
            }
        }
    } catch (const NPQ::TConsumer::TCreateConsumerTimeoutException& e) {
        Log->error(e.what());
    }
}

TReader::~TReader() {
    StopAndJoin();
}
