#pragma once

#include <crypta/lib/native/pqlib/consumer.h>
#include <crypta/lib/native/pqlib/cookie_queue.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/thread/threaded.h>

namespace NCrypta::NPQ {
    class TReader : public TThreaded {
    public:
        using TProcessFunction = std::function<void(TConsumer::TReadResult&&)>;

        TReader(
            TDuration readTimeout,
            NPQ::TConsumer& consumer,
            TCookieQueue& cookiesToCommit,
            TProcessFunction processFunction,
            NLog::TLogPtr log
        );

        void Run() override;

        ~TReader();

    private:
        const TDuration ReadTimeout;
        TConsumer& Consumer;
        TCookieQueue& CookiesToCommit;
        TProcessFunction ProcessFunction;
        NLog::TLogPtr Log;
    };
}
