#pragma once

#include <crypta/lib/native/stats/stats.h>

#include <kikimr/persqueue/sdk/deprecated/cpp/v2/persqueue.h>

namespace NCrypta::NPQ {
    class TSinglePartitionProducer {
    public:
        using TCommitResponseFuture = NThreading::TFuture<NPersQueue::TProducerCommitResponse>;

        TSinglePartitionProducer(NPersQueue::TPQLib& pqLib,
                                 const NPersQueue::TProducerSettings& producerSettings,
                                 TIntrusivePtr<NPersQueue::ILogger>& logger,
                                 TStats& stats);

        void Start(TDuration timeout = TDuration::Max());
        TCommitResponseFuture Write(TString data);

    private:
        void Log(ELogPriority priority, const TString& message, const NPersQueue::WriteResponse& response);

        THolder<NPersQueue::IProducer> Producer;
        TString SourceId;
        NPersQueue::TProducerSeqNo SeqNo = 0;

        TIntrusivePtr<NPersQueue::ILogger>& Logger;
        TStats& Stats;
    };
}
