#include "remove_secrets.h"

#include <crypta/lib/proto/extensions/extensions.pb.h>

#include <util/generic/yexception.h>

using namespace NCrypta;

void NProtoSecrets::RemoveSecrets(NProtoBuf::Message& message) {
    const auto* descriptor = message.GetDescriptor();
    const auto* reflection = message.GetReflection();

    for (int i = 0; i < descriptor->field_count(); ++i) {
        const auto* fieldDescriptor = descriptor->field(i);
        const auto fieldType = fieldDescriptor->cpp_type();
        const auto& fieldOptions = fieldDescriptor->options();
        const bool hasIsSecret = fieldOptions.HasExtension(NCryptaOpts::IsSecret);
        const bool isSecret = fieldOptions.GetExtension(NCryptaOpts::IsSecret);
        const bool hasFromEnv = fieldOptions.HasExtension(NCryptaOpts::FromEnv);
        const bool isRepeated = fieldDescriptor->is_repeated();
        const bool isString = (fieldType == NProtoBuf::FieldDescriptor::CppType::CPPTYPE_STRING);

        Y_ENSURE(!hasIsSecret || (!isRepeated && isString), "IsSecret may apply to singular string only");

        if (!isRepeated && !reflection->HasField(message, fieldDescriptor)) {
            continue;
        }

        if (fieldType == NProtoBuf::FieldDescriptor::CppType::CPPTYPE_MESSAGE) {
            if (!isRepeated) {
                RemoveSecrets(*reflection->MutableMessage(&message, fieldDescriptor));
            } else {
                for (int j = 0; j < reflection->FieldSize(message, fieldDescriptor); ++j) {
                    RemoveSecrets(*reflection->MutableRepeatedMessage(&message, fieldDescriptor, j));
                }
            }
        } else if (isSecret || (hasFromEnv && !hasIsSecret)) {
            if (fieldType == NProtoBuf::FieldDescriptor::CppType::CPPTYPE_STRING) {
                reflection->SetString(&message, fieldDescriptor, "<secret>");
            }
        }
    }
}
