#pragma once

#include <google/protobuf/message.h>

namespace NCrypta::NProtoSecrets {
    void RemoveSecrets(NProtoBuf::Message& message);

    template <typename TProto>
    TProto GetCopyWithoutSecrets(const TProto& message) {
        TProto result;
        result.CopyFrom(message);

        RemoveSecrets(result);

        return result;
    }
}
