#include "proto_serializer.h"

#include "utf8_escape_transform.h"

#include <library/cpp/protobuf/json/proto2json.h>

TString NCrypta::NProtoSerializer::ToString(const google::protobuf::Message& message) {
    TString result;
    Y_ENSURE(message.SerializeToString(&result), "Failed to serialize proto: " << message.ShortDebugString());
    return result;
}

TString NCrypta::NProtoSerializer::ToJson(const google::protobuf::Message& message) {
    static const auto config = NProtobufJson::TProto2JsonConfig()
        .SetMissingSingleKeyMode(NProtobufJson::TProto2JsonConfig::MissingKeyDefault)
        .SetEnumMode(NProtobufJson::TProto2JsonConfig::EnumNameLowerCase)
        .AddStringTransform(MakeIntrusive<TUtf8EscapeTransform>())
        .SetFieldNameMode(NProtobufJson::TProto2JsonConfig::FieldNameSnakeCase);

    return NProtobufJson::Proto2Json(message, config);
}
