#pragma once

#include <google/protobuf/message.h>

#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/protobuf/json/json2proto.h>

#include <util/generic/string.h>

namespace NCrypta::NProtoSerializer {
    const NProtobufJson::TJson2ProtoConfig JSON_TO_PROTO_CONFIG{
        .FieldNameMode = NProtobufJson::TJson2ProtoConfig::FieldNameSnakeCase,
        .EnumValueMode = NProtobufJson::TJson2ProtoConfig::EnumCaseInsensetive};


    template <typename TStr>
    void FromString(google::protobuf::Message& message, const TStr& str) {
        Y_ENSURE(message.ParseFromArray(str.data(), str.length()), "Failed to parse proto");
    }

    template <typename TProto, typename TStr>
    TProto CreateFromString(const TStr& str) {
        TProto proto;
        FromString(proto, str);
        return proto;
    }

    template <typename TProto>
    TProto CreateFromJsonValue(const NJson::TJsonValue& json) {
        TProto proto;
        NProtobufJson::Json2Proto(json, proto, JSON_TO_PROTO_CONFIG);
        return proto;
    }

    template <typename TStr>
    void FromJson(google::protobuf::Message& message, const TStr& str) {
        NProtobufJson::Json2Proto(str, message, JSON_TO_PROTO_CONFIG);
    }

    TString ToString(const google::protobuf::Message& message);
    TString ToJson(const google::protobuf::Message& message);
}
