#pragma once

#include <iterator>

template <typename TIter>
class TIterRange {
public:
    using iterator = TIter;
    using const_iterator = TIter;

    TIterRange(const TIter& begin, const TIter& end)
        : Begin(begin)
        , End(end)
    {
    }

    TIter begin() const {
        return Begin;
    }

    TIter end() const {
        return End;
    }

    decltype(std::distance(TIter(), TIter())) size() const {
        return std::distance(Begin, End);
    }

    bool empty() const {
        return size() == 0;
    }

private:
    TIter Begin;
    TIter End;
};

template <typename TIter>
TIterRange<TIter> MakeRange(const TIter& begin, const TIter& end) {
    return TIterRange<TIter>(begin, end);
}
