#pragma once

#include "iter_range.h"

#include <util/generic/vector.h>

template <typename TIter>
class TPacksIter {
public:
    TPacksIter() {
    }

    TPacksIter(const TIter& currentPackBegin, const TIter& end, size_t packSize)
        : CurrentPackBegin(currentPackBegin)
        , CurrentPackEnd(currentPackBegin)
        , End(end)
        , PackSize(packSize)
    {
        operator++();
    }

    TPacksIter(const TPacksIter& other)
        : CurrentPackBegin(other.CurrentPackBegin)
        , CurrentPackEnd(other.CurrentPackBegin)
        , End(other.End)
        , PackSize(other.PackSize)
    {
    }

    TPacksIter& operator=(const TPacksIter& other) {
        if (&other == this) {
            return *this;
        }

        CurrentPackBegin = other.CurrentPackBegin;
        CurrentPackBegin = other.CurrentPackEnd;
        End = other.End;
        PackSize = other.PackSize;

        return *this;
    }

    TPacksIter& operator++() {
        CurrentPackBegin = CurrentPackEnd;

        for (size_t i = 0; (i < PackSize) && (CurrentPackEnd != End); i++) {
            ++CurrentPackEnd;
        }

        return *this;
    }

    TPacksIter& operator++(int) {
        TPacksIter prev = *this;

        operator++();

        return prev;
    }

    TIterRange<TIter> operator*() const {
        return TIterRange<TIter>(CurrentPackBegin, CurrentPackEnd);
    }

    bool operator==(const TPacksIter& other) const {
        return CurrentPackBegin == other.CurrentPackBegin;
    }

    bool operator!=(const TPacksIter& other) const {
        return !operator==(other);
    }

private:
    TIter CurrentPackBegin;
    TIter CurrentPackEnd;
    const TIter End;
    const size_t PackSize;
};

template <typename TIter>
class TPacks {
public:
    TPacks(const TIter& begin, const TIter& end, size_t packSize)
        : Begin(begin)
        , End(end)
        , PackSize(packSize)
    {
    }

    TPacksIter<TIter> begin() const {
        return TPacksIter<TIter>(Begin, End, PackSize);
    }

    TPacksIter<TIter> end() const {
        return TPacksIter<TIter>(End, End, PackSize);
    }

private:
    const TIter Begin;
    const TIter End;
    const size_t PackSize;
};

template <typename TIter>
TPacks<TIter> GetPacks(const TIter& begin, const TIter& end, size_t packSize) {
    return TPacks<TIter>(begin, end, packSize);
}

template <typename T>
TPacks<typename TVector<T>::const_iterator> GetPacks(const TVector<T>& vector, size_t packSize) {
    return TPacks<typename TVector<T>::const_iterator>(vector.begin(), vector.end(), packSize);
}
