#pragma once

#include <netdb.h>
#include <netinet/in.h>
#include <string.h>
#include <util/generic/string.h>
#include <variant>

namespace NCrypta::NResolver {
    class TResolveResult : public std::variant<std::monostate, in_addr, in6_addr> {
    public:
        using std::variant<std::monostate, in_addr, in6_addr>::variant;
        const static TString NotResolved;

        int SelectedFamily() const;
    };

    TResolveResult Resolve(const TString& host, int prefferedFamily=AF_INET);

    template <int AF>
    bool TryResolve(const char* hostname, void* dest) {
        hostent* hep;
#if defined(_linux_)
        hostent he;
        char buffer[4096];
        int err;

        gethostbyname2_r(hostname, AF, &he, buffer, sizeof(buffer), &hep, &err);
#elif defined(_freebsd_) || defined(_darwin_)
        // https://lists.apple.com/archives/darwin-dev/2006/May/msg00004.html
        hep = gethostbyname2(hostname, AF);
#else
#error Unsupported platform
#endif
        if (hep != NULL) {
            memcpy(dest, hep->h_addr, hep->h_length);
            return true;
        }

        return false;
    }

    template <int AF, typename TAddressType>
    TString ToString(const TAddressType& addr) {
        char buf[INET6_ADDRSTRLEN];

        inet_ntop(AF, &addr, buf, sizeof(buf));

        return TString{buf};
    }
}

TString ToString(const in_addr& addr);
TString ToString(const in6_addr& addr);
TString ToString(const NCrypta::NResolver::TResolveResult& rr);
