#include <crypta/lib/native/resolver/resolver.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NCrypta::NResolver;

namespace {
    const TString hostToResolve4 = "ns2.yandex.net";
    const TString hostToResolve6 = "crypta.yandex-team.ru";
    const TString hostToNoResolve = "wow.yoy.zheglov.xyz";
}

Y_UNIT_TEST_SUITE(NCryptaResolve) {
    Y_UNIT_TEST(v4orv6) {
        auto result = Resolve(hostToResolve4);

        if (std::holds_alternative<in_addr>(result)) {
            UNIT_ASSERT_EQUAL(ToString(result), "93.158.134.1");
        } else { // no v4
            UNIT_ASSERT_EQUAL(std::holds_alternative<in6_addr>(result), true);
            UNIT_ASSERT_EQUAL(ToString(result), "2a02:6b8:0:1::1");
        }
    }

    Y_UNIT_TEST(v6) {
        auto result = Resolve(hostToResolve6);
        UNIT_ASSERT_EQUAL(std::holds_alternative<std::monostate>(result), false);
        UNIT_ASSERT_EQUAL(std::holds_alternative<in_addr>(result), false);
        UNIT_ASSERT_EQUAL(std::holds_alternative<in6_addr>(result), true);
    }

    Y_UNIT_TEST(ToString) {
        auto result = Resolve(hostToResolve6);
        UNIT_ASSERT_EQUAL(ToString(std::get<in6_addr>(result)), "2a02:6b8:0:3400:0:7b5a:0:2");
        UNIT_ASSERT_EQUAL(ToString(result), "2a02:6b8:0:3400:0:7b5a:0:2");
    }

    Y_UNIT_TEST(NoResult) {
        auto result = Resolve(hostToNoResolve);
        UNIT_ASSERT_EXCEPTION(std::get<in_addr>(result), std::exception);
        UNIT_ASSERT_EXCEPTION(std::get<in6_addr>(result), std::exception);
        UNIT_ASSERT_EQUAL(std::holds_alternative<std::monostate>(result), true);
    }

    Y_UNIT_TEST(GetPrefferedFamily) {
        UNIT_ASSERT_EQUAL(Resolve(hostToResolve6).SelectedFamily(), AF_INET6);
        UNIT_ASSERT_EQUAL(Resolve(hostToNoResolve).SelectedFamily(), AF_UNSPEC);
    }
}
