#include "client.h"

#include <library/cpp/http/fetch/exthttpcodes.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>

#include <util/string/cast.h>
#include <util/string/join.h>

using namespace NCrypta::NResourceService;

TClient::TClient(const TCachingProxyClientOptions& options)
    : Options(options) {
}

ui64 TClient::GetVersion(const TString& resourceName) {
    auto url = Join("/", Options.GetEndpointOptions().GetUrlPrefix(), "version", Options.GetCluster(), resourceName);
    auto response = RequestWithTimeout(url);

    NJson::TJsonValue jsonResponse;
    NJson::ReadJsonTree(response->Data, &jsonResponse, true);
    return jsonResponse["version"].GetIntegerSafe();
}

TString TClient::GetResource(const TString& resourceName, ui64 version) {
    auto url = Join("/", Options.GetEndpointOptions().GetUrlPrefix(), "get", Options.GetCluster(), resourceName, ToString(version));
    auto response = RequestWithTimeout(url);

    return std::move(response->Data);
}

void TClient::ReportOk(const TString& resourceName, ui64 version) {
    auto url = Join("/", Options.GetEndpointOptions().GetUrlPrefix(), "report_ok", Options.GetCluster(), resourceName, ToString(version));
    RequestWithTimeout(url);
}

NHttpFetcher::TResultRef TClient::RequestWithTimeout(const TString& url) {
    using namespace NHttp;

    auto timeout = TDuration::Seconds(Options.GetEndpointOptions().GetTimeoutSec());
    TFetchClient fetcher;
    TFetchQuery query{
                url,
                TFetchOptions{}.SetTimeout(timeout)
    };

    NHttpFetcher::TResultRef response = fetcher.Fetch(query, {}).Get();;

    Y_ENSURE(response, "Timeout fetching " << url);
    Y_ENSURE(response->Success(), ExtHttpCodeStr(response->Code));

    return response;
}
