#pragma once

#include <crypta/lib/proto/resource_service/caching_proxy_client_options.pb.h>

#include <library/cpp/http/client/client.h>

#include <util/generic/maybe.h>

namespace NCrypta::NResourceService {
    class IClient {
    public:
        virtual ui64 GetVersion(const TString& resourceName) = 0;
        virtual TString GetResource(const TString& resourceName, ui64 version) = 0;
        virtual void ReportOk(const TString& resourceName, ui64 version) = 0;
        virtual ~IClient() = default;
    };

    class TClient : public IClient {
    public:
        TClient(const TCachingProxyClientOptions& options);
        ui64 GetVersion(const TString& resourceName) override;
        TString GetResource(const TString& resourceName, ui64 version) override;
        void ReportOk(const TString& resourceName, ui64 version) override;

        ~TClient() override = default;
    private:
        NHttpFetcher::TResultRef RequestWithTimeout(const TString& url);

        const TCachingProxyClientOptions Options;
    };
}
