#include <crypta/lib/native/resource_service/client/client.h>
#include <crypta/lib/proto/endpoint_options/endpoint_options.pb.h>

#include <library/cpp/json/json_value.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/system/env.h>

using namespace NCrypta;
using namespace NResourceService;

namespace {
    TClient GetClient() {
        TCachingProxyClientOptions options;
        auto& endpointOptions = *options.MutableEndpointOptions();

        endpointOptions.SetUrlPrefix(GetEnv("RESOURCE_SERVICE_URL_PREFIX"));
        endpointOptions.SetTimeoutSec(5);

        return TClient(options);
    }
}

Y_UNIT_TEST_SUITE(TClient) {
    Y_UNIT_TEST(GetVersion) {
        auto client = GetClient();
        UNIT_ASSERT_EQUAL(1, client.GetVersion("present"));
    }

    Y_UNIT_TEST(GetVersionNotFound) {
        auto client = GetClient();
        UNIT_ASSERT_EXCEPTION(client.GetVersion("not_found"), yexception);
    }

    Y_UNIT_TEST(GetResource) {
        auto client = GetClient();

        UNIT_ASSERT_EQUAL("some content", client.GetResource("present", 1));

        UNIT_ASSERT_EXCEPTION(client.GetResource("present", 2), yexception);
        UNIT_ASSERT_EXCEPTION(client.GetResource("not_found", 3), yexception);
    }

    Y_UNIT_TEST(ReportOk) {
        auto client = GetClient();
        UNIT_ASSERT_NO_EXCEPTION(client.ReportOk("present", 1));
        UNIT_ASSERT_EXCEPTION(client.ReportOk("not_found", 3), yexception);
    }
}
