#include "extfp_source_parser.h"
#include "crypta/lib/native/resource_service/parsers/extfp_source_parser/extfp_source_desc.pb.h"

#include <crypta/lib/native/string_archive/string_archive.h>
#include <crypta/lib/native/yaml/yaml2proto.h>

#include <library/cpp/resource/resource.h>
#include <util/generic/buffer.h>
#include <util/generic/vector.h>
#include <util/stream/str.h>
#include <util/stream/output.h>

namespace NCrypta::NResourceService {
    TSourcesDescriptions TExtfpSourceParser::Parse(const TString& input) {
        TSourcesDescriptions result;

        auto allData = NCrypta::NStringArchive::Unarchive(input);

        for (const auto& fileInfo : allData) {
            auto proto = NCrypta::Yaml2Proto<TExtfpSourcesDesc>(fileInfo.Data);
            for (const auto& [sourceId, filterDesc] : proto.GetSources()) {
                result.emplace_back(sourceId, filterDesc);
            }
        }

        Y_ENSURE(!result.empty(), "No sources were found in archive");
        return result;
    }

    TSourcesDescriptions MakeSourcesFromResource(const TString& resourceName) {
        return TExtfpSourceParser::Parse(NResource::Find(resourceName));
    }
}
