#include "source_description.h"

namespace NCrypta::NResourceService {
    TSourceDescription::TSourceDescription(const TString& sourceId, const TExtfpSourceDesc& filterDesc)
        : SourceId(sourceId)
        , Filter(filterDesc.GetIps())
        , Enabled(filterDesc.GetEnabled())
        , Delayed(filterDesc.GetDelayed())
        , MatchOnlyItp(filterDesc.GetMatchItpOnly())
        , IdsToMatch(filterDesc.GetIdsToMatch().begin(), filterDesc.GetIdsToMatch().end())
    {
    }

    const TString& TSourceDescription::GetSource() const {
        return SourceId;
    }

    const TIpFilter& TSourceDescription::GetFilter() const {
        return Filter;
    }

    bool TSourceDescription::IsEnabled() const {
        return Enabled;
    }

    bool TSourceDescription::IsDelayed() const {
        return Delayed;
    }

    bool TSourceDescription::MatchItpOnly() const {
        return MatchOnlyItp;
    }

    const TSourceDescription::TIdsToMatchStorage& TSourceDescription::GetIdsToMatch() const {
        return IdsToMatch;
    }

    bool TSourceDescription::IsPassingByIp(const TStringBuf ip) const {
        return Enabled && Filter.IsPassing(ip);
    }

    bool TSourceDescription::IsPassingBySourceId(const TStringBuf sourceId) const {
        return Enabled && (Find(IdsToMatch.begin(), IdsToMatch.end(), sourceId) != IdsToMatch.end());
    }

    bool TSourceDescription::IsPassing(const TStringBuf ip, const TStringBuf sourceId) const {
        return IsPassingByIp(ip) || IsPassingBySourceId(sourceId);
    }
}
