#pragma once

#include <crypta/lib/native/ip_filter/ip_filter.h>
#include <crypta/lib/native/resource_service/parsers/extfp_source_parser/extfp_source_desc.pb.h>

#include <util/generic/vector.h>

namespace NCrypta::NResourceService {
    class TSourceDescription {
    public:
        using TIdsToMatchStorage = TVector<TString>;

        TSourceDescription(const TString& sourceId, const TExtfpSourceDesc& filterDesc);

        bool IsPassing(const TStringBuf ip, const TStringBuf sourceId) const;
        bool IsPassingByIp(const TStringBuf ip) const;
        bool IsPassingBySourceId(const TStringBuf sourceId) const;

        const TString& GetSource() const;
        const TIpFilter& GetFilter() const;
        bool IsEnabled() const;
        bool IsDelayed() const;
        bool MatchItpOnly() const;
        const TSourceDescription::TIdsToMatchStorage& GetIdsToMatch() const;

    private:
        TString SourceId;
        TIpFilter Filter;
        bool Enabled;
        bool Delayed;
        bool MatchOnlyItp;
        TIdsToMatchStorage IdsToMatch;
    };

    using TSourcesDescriptions = TVector<TSourceDescription>;
}
