#pragma once

#include "resource_meta.h"

#include <util/datetime/base.h>
#include <util/generic/ptr.h>

namespace NCrypta::NResourceService {
    template <typename TValue>
    struct TResource : public TThrRefBase {
        explicit TResource(TValue&& value, TResourceMeta meta)
            : Value(std::forward<TValue>(value))
            , Meta(std::move(meta))
        {
        }

        const TValue Value;
        TResourceMeta Meta;
    };

    template <typename TValue>
    using TResourcePtr = TIntrusivePtr<TResource<TValue>>;
}
