#pragma once

#include "provider.h"
#include "resource.h"
#include "updatable.h"

#include <library/cpp/threading/hot_swap/hot_swap.h>

namespace NCrypta::NResourceService {
    template<typename TValue, typename TParser>
    class TUpdatableProvider : public TMoveOnly, public IProvider<TValue>, public IUpdatable {
    public:
        TUpdatableProvider(TValue defaultValue, TString name)
            : Resource(new TResource<TValue>(std::move(defaultValue), TResourceMeta(std::move(name))))
        {
        }

        void Update(const TString &raw, ui64 version) override {
            Resource.AtomicStore(MakeIntrusive<TResource<TValue>>(
                    TParser::Parse(raw),
                    TResourceMeta(GetResource()->Meta.Name, version)));
        }

        const TResourcePtr<TValue> GetResource() const override {
            return Resource.AtomicLoad();
        }

        TResourceMeta GetResourceMeta() const override {
            return Resource.AtomicLoad()->Meta;
        }

        ~TUpdatableProvider() override = default;

    private:
        THotSwap<TResource<TValue>> Resource;
    };
}
