#include "reporter.h"

#include <crypta/lib/native/resource_service/client/client.h>

#include <util/stream/str.h>

using namespace NCrypta::NResourceService;

void TReporter::Report() {
    TGuard lock(Mutex);
    for (auto& metaProviderState: MetaProviderStates) {
        ReportResource(metaProviderState);
    }
}

void TReporter::ReportResource(TMetaProviderState& metaProviderState) {
    const auto& resourceMeta = metaProviderState.MetaProvider.GetResourceMeta();
    if (!resourceMeta.Version) {
        return;
    }

    const auto& now = TInstant::Now();
    if (now - resourceMeta.CreationTime < TDuration::Seconds(Options.GetResourceOkAgeSec())) {
        return;
    }

    if (metaProviderState.LastReportedVersion == resourceMeta.Version && now - *metaProviderState.LastReportAttempt < TDuration::Seconds(Options.GetResourceOkRepeatSec())) {
        return;
    }

    metaProviderState.LastReportAttempt = now;

    auto reportOkFunc = [&]() {
        Client->ReportOk(resourceMeta.Name, resourceMeta.Version);
        metaProviderState.LastReportedVersion = resourceMeta.Version;
    };

    DoWithRetry<std::exception>(reportOkFunc, RetryOptions, false);
}

void TReporter::Start() {
    Runner.Start();
}
