#pragma once

#include <crypta/lib/native/periodic_task/periodic_task.h>
#include <crypta/lib/native/resource_service/client/client.h>
#include <crypta/lib/native/resource_service/provider/meta_provider.h>
#include <crypta/lib/proto/resource_service/reporter_options.pb.h>

#include <library/cpp/retry/retry.h>

#include <util/generic/vector.h>

namespace NCrypta::NResourceService {
    class TReporter {
    public:
        template <typename TContainer>
        TReporter(
            const TReporterOptions& options,
            THolder<IClient> client,
            TContainer&& metaProviders,
            const TString& threadName = "resource-reporter"
        )
            : Options(options)
            , RetryOptions(MakeRetryOptions(options.GetRetryOptions()))
            , Client(std::move(client))
            , Runner(TDuration::Seconds(options.GetReportIntervalSec()), [this](){ Report(); }, threadName, false)
        {
            for (const auto& metaProvider: metaProviders) {
                MetaProviderStates.emplace_back(metaProvider);
            }
        }

        void Report();
        void Start();

    private:
        struct TMetaProviderState {
            const IMetaProvider& MetaProvider;
            TMaybe<ui64> LastReportedVersion;
            TMaybe<TInstant> LastReportAttempt;

            explicit TMetaProviderState(const IMetaProvider& provider)
                : MetaProvider(provider)
            {
            }
        };

        void ReportResource(TMetaProviderState& metaProviderState);

        TVector<TMetaProviderState> MetaProviderStates;
        TMutex Mutex;

        const TReporterOptions Options;
        TRetryOptions RetryOptions;
        THolder<IClient> Client;
        TPeriodicTask Runner;
    };
}
