#include "service.h"

#include <crypta/lib/native/juggler/juggler_client.h>
#include <crypta/lib/native/resource_service/client/client.h>

#include <util/system/hostname.h>

using namespace NCrypta::NResourceService;

namespace {
    TString GetHost() {
        try {
            return FQDNHostName();
        } catch (const yexception& TSystemError) {
        }
        return HostName();
    }
}

TService::TService(const TServiceOptions& options, const TVector<std::reference_wrapper<IUpdatable>>& updatables)
    : Updater(
            options.GetUpdaterOptions(),
            MakeHolder<TClient>(options.GetCachingProxyClientOptions()),
            MakeHolder<TJugglerClient>(options.GetJugglerClientOptions()),
            updatables,
            GetHost())
    , Reporter(
            options.GetReporterOptions(),
            MakeHolder<TClient>(options.GetCachingProxyClientOptions()),
            updatables)
{
    if (options.GetWaitForUpdate()) {
        Updater.Update();
    }

    Updater.Start();
    Reporter.Start();
}
