#pragma once

#include <crypta/lib/native/juggler/juggler_client.h>
#include <crypta/lib/native/periodic_task/periodic_task.h>
#include <crypta/lib/native/resource_service/client/client.h>
#include <crypta/lib/native/resource_service/provider/updatable.h>
#include <crypta/lib/proto/resource_service/updater_options.pb.h>

#include <library/cpp/retry/retry.h>

#include <util/generic/vector.h>

namespace NCrypta::NResourceService {
    class TUpdater {
    public:
        using TServiceNameBuilder = std::function<TString(const TString&)>;

        template <typename TContainer>
        TUpdater(
            const TUpdaterOptions& options,
            THolder<IClient> client,
            THolder<IJugglerClient> jugglerClient,
            TContainer&& updatables,
            TString host,
            TServiceNameBuilder serviceConverter = GetDefaultServiceNameBuilder(),
            const TString& threadName = "resource-updater"
        )
            : Options(options)
            , RetryOptions(options.GetRetryCount(), TDuration::Seconds(options.GetRetryIntervalSec()))
            , Client(std::move(client))
            , JugglerClient(std::move(jugglerClient))
            , Host(std::move(host))
            , ServiceNameBuilder(std::move(serviceConverter))
            , Runner(TDuration::Seconds(options.GetUpdateIntervalSec()), [this](){ Update(); }, threadName, true)
        {
            for (auto& updateable: updatables) {
                Updatables.emplace_back(updateable);
            }
        }

        void Update();
        void Start();

        static TServiceNameBuilder GetDefaultServiceNameBuilder();
        static const TString JugglerOkDescription;

    private:
        void UpdateResource(IUpdatable& updatable);

        TVector<std::reference_wrapper<IUpdatable>> Updatables;
        TMutex Mutex;

        const TUpdaterOptions Options;
        TRetryOptions RetryOptions;
        THolder<IClient> Client;
        THolder<IJugglerClient> JugglerClient;
        const TString Host;
        const TServiceNameBuilder ServiceNameBuilder;
        TPeriodicTask Runner;
    };
}
