#pragma once

#include "type.h"

#include <util/system/types.h>

namespace NCrypta::NRetargetingIds {
    class TRetargetingId {
    public:
        explicit TRetargetingId(ui64 retargetingId);
        TRetargetingId(ui64 entityId, EType type);

        bool operator==(const TRetargetingId& rhs) const;
        bool operator!=(const TRetargetingId& rhs) const;

        ui64 GetEntityId() const;
        EType GetType() const;
        ui64 Serialize() const;

    private:
        ui64 EntityId = 0;
        EType Type = EType::Unknown;
    };
}
