#include <crypta/lib/native/retargeting_ids/retargeting_id.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NCrypta::NRetargetingIds;

Y_UNIT_TEST_SUITE(TRetargetingId) {
    Y_UNIT_TEST(Basic) {
        UNIT_ASSERT_EQUAL(TRetargetingId(100, EType::MetrikaGoal), TRetargetingId(100));
        UNIT_ASSERT_EQUAL(TRetargetingId(1, EType::MetrikaAudienceSegment), TRetargetingId(2'000'000'001));
        UNIT_ASSERT_EQUAL(TRetargetingId(1, EType::MetrikaCounter), TRetargetingId(4'000'000'001));
        UNIT_ASSERT_EQUAL(TRetargetingId(1'900'000'001, EType::MobileEvent), TRetargetingId(1'900'000'001));
    }

    Y_UNIT_TEST(Serialize) {
        UNIT_ASSERT_EQUAL(100, TRetargetingId(100, EType::MetrikaGoal).Serialize());
        UNIT_ASSERT_EQUAL(2'000'000'001, TRetargetingId(1, EType::MetrikaAudienceSegment).Serialize());
        UNIT_ASSERT_EQUAL(4'000'000'001, TRetargetingId(1, EType::MetrikaCounter).Serialize());
        UNIT_ASSERT_EQUAL(1'900'000'001, TRetargetingId(1'900'000'001, EType::MobileEvent).Serialize());
    }
}
