#include "rps_limiter.h"

using namespace NCrypta;

TRpsLimiter::TRpsLimiter(ui64 rpsLimit)
    : RpsLimit(rpsLimit)
    , RequestCount((ui64)0)
    , LastTime(TInstant::Now())
{
}

bool TRpsLimiter::OneMoreTimeIsPossible() {
    if (RpsLimit == 0) {
        return true;
    }

    if (RequestCount >= RpsLimit) {
        auto now = TInstant::Now();
        if (LastTime + GRANULARITY_ONE_SEC < now) {
            LastTime = now;
            RequestCount = 1;
            return true;
        } else {
            return false;
        }
    } else {
        ++RequestCount;
        return true;
    }
}

const TDuration TRpsLimiter::GRANULARITY_ONE_SEC;
