#pragma once

#include <util/datetime/base.h>

namespace NCrypta {
    class TRpsLimiter {
    public:
        explicit TRpsLimiter(ui64 rpsLimit);
        bool OneMoreTimeIsPossible();

    private:
        static constexpr TDuration GRANULARITY_ONE_SEC = TDuration::Seconds(1);

        ui64 RpsLimit = 0;
        ui64 RequestCount = 0;
        TInstant LastTime = TInstant::Zero();
    };
}
