#pragma once

#include <crypta/lib/native/rtmr/benchmark_utils/proto/job_input.pb.h>
#include <crypta/lib/native/time/shifted_clock.h>
#include <crypta/lib/native/yt/test_utils/test_yamr_reader.h>
#include <crypta/lib/native/yt/test_utils/void_writer.h>

#include <library/cpp/testing/benchmark/bench.h>
#include <mapreduce/yt/interface/io.h>

#include <util/generic/xrange.h>

namespace NCrypta {
    struct TInputRowGetter {
        static size_t GetIndex(const TInputRow& row);
        static NYT::TYaMRRow GetRow(const TInputRow& row);
    };

    template<typename TOperation, typename TRunner>
    void Benchmark(::NBench::NCpu::TParams& iface, const TString& rawJobInput, TOperation& operation, size_t outputStreamCount, TRunner runner) {
        TJobInput jobInput;
        Y_PROTOBUF_SUPPRESS_NODISCARD jobInput.ParseFromString(rawJobInput);
        TShiftedClock::FreezeTimestamp(jobInput.GetTimestamp());

        NYT::TYaMRWriter writer(MakeIntrusive<TVoidWriter>(outputStreamCount));

        auto readerImpl = MakeIntrusive<NYtTestUtils::TTestYamrReader<::google::protobuf::RepeatedPtrField<TInputRow>, TInputRowGetter>>(jobInput.GetItems(0).GetInputRows());
        NYT::TYaMRReader reader(readerImpl);
        TStringStream outputStateStream;

        for (const auto i : xrange(iface.Iterations())) {
            Y_UNUSED(i);
            for (const auto& item: jobInput.GetItems()) {
                TMemoryInput inputStateStream(TStringBuf(item.GetInputState()));
                outputStateStream.Clear();
                readerImpl->Reset(item.GetInputRows());

                runner(operation, inputStateStream, outputStateStream, reader, writer);
            }
        }
    }

    template<typename TStatefulOperation>
    void BenchmarkStateful(::NBench::NCpu::TParams& iface, const TString& rawJobInput, TStatefulOperation& operation, size_t outputStreamCount) {
        auto runner = [](TStatefulOperation& operation, IInputStream& inputState, IOutputStream& outputState, NYT::TYaMRReader& reader, NYT::TYaMRWriter& writer) {
            operation.ResetState();
            operation.LoadState(inputState);
            operation.Do(&reader, &writer);
            operation.SaveState(outputState);
        };
        Benchmark(iface, rawJobInput, operation, outputStreamCount, runner);
    }

    template<typename TStatelessOperation>
    void BenchmarkStateless(::NBench::NCpu::TParams& iface, const TString& rawJobInput, TStatelessOperation& operation, size_t outputStreamCount) {
        auto runner = [](TStatelessOperation& operation, IInputStream& inputState, IOutputStream& outputState, NYT::TYaMRReader& reader, NYT::TYaMRWriter& writer) {
            Y_UNUSED(inputState, outputState);
            operation.Do(&reader, &writer);
        };
        Benchmark(iface, rawJobInput, operation, outputStreamCount, runner);
    }
}
