#pragma once

#include <rtmapreduce/libs/mapreduce-yt/operation.h>

namespace NCrypta {
    template <typename TState>
    class TProtoStatefulOperation: public NRTMR::NTask::IStatefulOperation {
    public:
        void ResetState() override {
            State.Clear();
        }

        void LoadState(IInputStream& in) override {
            Y_ENSURE(State.ParseFromArcadiaStream(&in), "Failed to parse state");
        }

        void SaveState(IOutputStream& out) const override {
            Y_ENSURE(State.SerializeToArcadiaStream(&out), "Failed to save state: " << State.ShortDebugString());
        }

    protected:
        TState State;
    };

    template <typename TState>
    class TProtoStatefulMapper
       : public TProtoStatefulOperation<TState>,
          public NYT::IMapper<NYT::TTableReader<NYT::TYaMRRow>, NYT::TTableWriter<NYT::TYaMRRow>> {
    };

    template <typename TState>
    class TProtoStatefulReducer
       : public TProtoStatefulOperation<TState>,
          public NYT::IReducer<NYT::TTableReader<NYT::TYaMRRow>, NYT::TTableWriter<NYT::TYaMRRow>> {
    };
}
