#include "errors_to_solomon_metrics_mapper.h"

#include <library/cpp/monlib/encode/json/json.h>

using namespace NCrypta;

namespace {
    const TString ERROR_TABLE = "error_table";

    NMonitoring::TLabels MakeLabels(const TString& errorTable) {
        return {{ERROR_TABLE, errorTable}};
    }
}

TErrorsToSolomonMetricsMapper::TErrorsToSolomonMetricsMapper(const TErrorsToSolomonMetricsMapperConfig& config)
    : AggregationInterval(TDuration::Seconds(config.GetAggregationIntervalSec())) {
    for (const auto& label: config.GetLabels()) {
        IndexToLabels.push_back(MakeLabels(label));
    }
}

void TErrorsToSolomonMetricsMapper::Do(TReader* reader, TWriter* writer) {
    THashMap<ui64, NMonitoring::TMetricRegistry> registries;

    for (; reader->IsValid(); reader->Next()) {
        const auto& row = reader->GetRow();
        const auto& labels = IndexToLabels.at(reader->GetTableIndex());

        auto ts = FromString<ui64>(row.SubKey) / AggregationInterval.Seconds() * AggregationInterval.Seconds();

        registries[ts].IntGauge(labels)->Inc();
    }

    for (const auto& [ts, registry]: registries) {
        TStringStream ss;
        auto encoder = NMonitoring::EncoderJson(&ss);
        registry.Accept(TInstant::Seconds(ts), encoder.Get());

        writer->AddRow({ToString(ts), "", ss.Str()});
    }
}
